using UnityEngine;
using System.Collections;

public class PlayerScript : MonoBehaviour {
	
	public GameObject mainCam;
	public GameObject animObj;
	
	private CharacterController cc;
	
	private Vector3 camAngle = new Vector3(0,180,0);
	
	private Vector3 lookDir = -Vector3.forward;
	
	public bool startingEngine = false;
	
	public bool holding = false;
	
	public bool theEnd = false;
	public float endFadeStart = 0;
	
	public TextMesh messageText;
	
	public float messageWipe = 0;
	public string message = "";
	
	// Use this for initialization
	void Start () {
		cc = GetComponent<CharacterController>();
		
		Screen.lockCursor = true;
	}
	
	// Update is called once per frame
	void Update () {
		
		messageText.text = message;
		if (Time.time>messageWipe){
			message = "";
		}
		
		
		if (!startingEngine && !theEnd){
			
			if (fadeCam.camera.enabled){
				
				fadeAlpha -= Time.deltaTime * 0.2f;
				fadePlane.renderer.material.SetColor("_Color", new Color(0,0,0,fadeAlpha));
				
				if (fadeAlpha<0){
					fadeCam.camera.enabled = false;
					fadeAlpha = 0;
				}
			}
			
			
			
			
			Vector3 inputVector = new Vector3();
			if (Input.GetKey("left") || Input.GetKey("a")) inputVector -= mainCam.transform.right;
			if (Input.GetKey("right") || Input.GetKey("d")) inputVector += mainCam.transform.right;
			if (Input.GetKey("up") || Input.GetKey("w")) inputVector += mainCam.transform.forward;
			if (Input.GetKey("down") || Input.GetKey("s")) inputVector -= mainCam.transform.forward;
			inputVector.y = 0;
			inputVector.Normalize();
			
			cc.Move(inputVector*Time.deltaTime*5f);
			cc.Move(Vector3.up*-10f*Time.deltaTime);
			
			
			
			if (inputVector.magnitude > 0.1f){
				lookDir = inputVector;
			}
			
			Quaternion lastRot = animObj.transform.rotation;
			animObj.transform.LookAt(animObj.transform.position + lookDir);
			animObj.transform.rotation = Quaternion.Slerp(lastRot, animObj.transform.rotation, 0.1f);
			
			
			if (inputVector.magnitude > 0.1f){
				animObj.animation.CrossFade("run");
				animObj.animation["run"].speed = 1.3f;
				animObj.GetComponent<BlahReceiver>().walking = true;
			}else{
				animObj.animation.CrossFade("idle");
				animObj.GetComponent<BlahReceiver>().walking = false;
			}
			
			mainCam.transform.position = transform.position + (Vector3.up*0.5f);
			camAngle.y += Input.GetAxis("Mouse X")*5f;
			camAngle.x -= Input.GetAxis("Mouse Y")*5f;
			
			if (camAngle.x < -30) camAngle.x = -30;
			if (camAngle.x > 88) camAngle.x = 88;
			
			mainCam.transform.eulerAngles = camAngle;
			mainCam.transform.Translate(1,0,-2);
			
		}else if (theEnd){
			Quaternion lastCamRot = mainCam.transform.rotation;
			mainCam.transform.position += Vector3.up * Time.deltaTime * 0.5f;
			mainCam.transform.LookAt(transform.position);
			mainCam.transform.rotation = Quaternion.Slerp(lastCamRot, mainCam.transform.rotation, 1f*Time.deltaTime);
			
			if (Time.time>endFadeStart){
				fadeCam.camera.enabled = true;
				fadeAlpha += Time.deltaTime * 0.2f;
				fadePlane.renderer.material.SetColor("_Color", new Color(0,0,0,fadeAlpha));
				
				if (fadeAlpha>1.3f){
					Screen.lockCursor = false;
					Application.LoadLevel("end");
				}
				
			}
			
		}
		
	}
	
	public GameObject fadeCam;
	public GameObject fadePlane;
	private float fadeAlpha = 1f;
	
	
}
