using UnityEngine;
using System.Collections;

public class DetectiveScript : MonoBehaviour {

	
	private Vector3 lookDir = Vector3.right;
	
	private bool running = false;
	public bool talking = false;
	
	public GameObject animObj;
	private CharacterController cc;
	
	public TextMesh messageText;
	public Camera hudCam;
	
	
	private string[] messages;
	private int currentmessage = 0;
	
	public void Talk(string[] messagesIn){
		messages = messagesIn;
		talking = true;
		currentmessage = 0;
	}
	
	// Use this for initialization
	void Start () {
		cc = GetComponent<CharacterController>();
	}
	
	// Update is called once per frame
	void Update () {
		
		if (Input.GetKeyDown("escape")){
			Application.LoadLevel(0);
		}
		
		
		running = false;
	
		if (!talking){
			hudCam.enabled = false;
			
			if (Input.GetKey("left")){
				running = true;
				lookDir = -Vector3.right;
				cc.Move(-Vector3.right * 5f * Time.deltaTime);
			}
			
			if (Input.GetKey("right")){
				running = true;
				lookDir = Vector3.right;
				cc.Move(Vector3.right * 5f * Time.deltaTime);
			}
			cc.Move (-Vector3.up * 15f * Time.deltaTime);
			
			
			
			
		}else{
			//talking
			hudCam.enabled = true;
			
			messageText.text = messages[currentmessage];
			
			if (Input.GetKeyDown("space")){
				currentmessage++;
				if (currentmessage >= messages.Length){
					talking = false;
				}else{
					if (messages[currentmessage] == "<END>"){
						Application.LoadLevel(0);
					}
					if (messages[currentmessage] == "<TWIST1>"){
						Application.LoadLevel("Detective4Twist");
					}
				}
			}
			
		}
		
		
		Quaternion lastRot = animObj.transform.rotation;
		animObj.transform.LookAt(animObj.transform.position + lookDir);
		animObj.transform.rotation = Quaternion.Slerp(lastRot, animObj.transform.rotation, 20f*Time.deltaTime);
		
		
		
		if (running){
			animObj.animation.CrossFade("run");
		}else{
			animObj.animation.CrossFade("idle");
		}
		
		
	}
}
