using UnityEngine;
using System.Collections;

public class boxFallScript : MonoBehaviour {
	
	
	public GameObject playerL;
	public GameObject playerM;
	public GameObject playerR;
	
	public Material solidMat;
	public Material redMat;
	public Material alphaMat;
	
	private string playerPos = "M";
	
	public GameObject[] boxesL;
	public GameObject[] boxesM;
	public GameObject[] boxesR;
	
	private bool[] boxL;
	private bool[] boxM;
	private bool[] boxR;
	
	private float changeSpeed = 0.5f;
	private float changeTime = 0f;
	
	private bool playing = false;
	
	private int score = 0;
	private int record = 0;

	// Use this for initialization
	void Start () {
		record = PlayerPrefs.GetInt("BoxFallRecord", 0);
	}
	
	public TextMesh messageText;
	
	
	// Update is called once per frame
	void Update () {
		
		if (Input.GetKey("escape")) Application.LoadLevel(0);
		
		
		if (!playing){
			
			messageText.text = "PRESS SPACE!";
			
			if (Input.GetKeyDown("space")){
				playing = true;
				changeTime = Time.time + changeSpeed;
				changeSpeed = 0.5f;
				
				boxL = new bool[boxesL.Length];
				boxM = new bool[boxesM.Length];
				boxR = new bool[boxesR.Length];
				
				score = 0;
				
				changeStep = 0;
				
				messageText.text = "";
			}
		}
		
		
		if (playing){
			
			if (Input.GetKeyDown("left")){
				if (playerPos == "M"){
					playerPos = "L";
				}else if (playerPos == "R"){
					playerPos = "M";
				}
			}
			if (Input.GetKeyDown("right")){
				if (playerPos == "M"){
					playerPos = "R";
				}else if (playerPos == "L"){
					playerPos = "M";
				}
			}
			
			
			
			if (playerPos != "L"){
				foreach (Transform child in playerL.transform){
					child.renderer.material = alphaMat;
				}
			}else{
				foreach (Transform child in playerL.transform){
					child.renderer.material = solidMat;
				}
			}
		
			if (playerPos != "M"){
				foreach (Transform child in playerM.transform){
					child.renderer.material = alphaMat;
				}
			}else{
				foreach (Transform child in playerM.transform){
					child.renderer.material = solidMat;
				}
			}
		
			if (playerPos != "R"){
				foreach (Transform child in playerR.transform){
					child.renderer.material = alphaMat;
				}
			}else{
				foreach (Transform child in playerR.transform){
					child.renderer.material = solidMat;
				}
			}
			
			
			
			
			if (Time.time > changeTime){
				changeTime = Time.time + changeSpeed;
				
				changeStep++;
				if (changeStep > 3){
					changeStep = 0;
					changeSpeed -= 0.01f;
				}
				
				for (int i=boxL.Length-1; i>0; i--){
					boxL[i] = boxL[i-1];
				}
				boxL[0] = false;
				if (Random.Range(0,100)<20) boxL[0] = true;
				
				for (int i=boxL.Length-1; i>0; i--){
					boxM[i] = boxM[i-1];
				}
				boxM[0] = false;
				if (Random.Range(0,100)<20) boxM[0] = true;
				
				for (int i=boxL.Length-1; i>0; i--){
					boxR[i] = boxR[i-1];
				}
				boxR[0] = false;
				if (Random.Range(0,100)<20) boxR[0] = true;
				
				
				
				for (int i=0; i<boxesL.Length; i++){
					if (boxL[i]){
						boxesL[i].renderer.material = solidMat;
					}else{
						boxesL[i].renderer.material = alphaMat;
					}
				}
				
				for (int i=0; i<boxesM.Length; i++){
					if (boxM[i]){
						boxesM[i].renderer.material = solidMat;
					}else{
						boxesM[i].renderer.material = alphaMat;
					}
				}
				
				for (int i=0; i<boxesR.Length; i++){
					if (boxR[i]){
						boxesR[i].renderer.material = solidMat;
					}else{
						boxesR[i].renderer.material = alphaMat;
					}
				}
				
				//collision
				if (boxL[boxL.Length-1] && playerPos == "L"){
					Die();
					foreach (Transform child in playerL.transform){
						child.renderer.material = redMat;
					}
					foreach (Transform child in playerM.transform){
						child.renderer.material = alphaMat;
					}
					foreach (Transform child in playerR.transform){
						child.renderer.material = alphaMat;
					}
				}
				if (boxM[boxM.Length-1] && playerPos == "M"){
					Die();
					foreach (Transform child in playerL.transform){
						child.renderer.material = alphaMat;
					}
					foreach (Transform child in playerM.transform){
						child.renderer.material = redMat;
					}
					foreach (Transform child in playerR.transform){
						child.renderer.material = alphaMat;
					}
				}
				if (boxR[boxR.Length-1] && playerPos == "R"){
					Die();
					foreach (Transform child in playerL.transform){
						child.renderer.material = alphaMat;
					}
					foreach (Transform child in playerM.transform){
						child.renderer.material = alphaMat;
					}
					foreach (Transform child in playerR.transform){
						child.renderer.material = redMat;
					}
				}
				
				
				score++;
				if (score>record){
					record = score;
					PlayerPrefs.SetInt("BoxFallRecord", record);
				}
				
			}
			
		}
		
		scoreText.text = "Score: " + score.ToString() + "     Record: " + record.ToString();
		
	}
	
	private int changeStep = 0;
	
	public TextMesh scoreText;
	
	void Die(){
		playing = false;
		
		
		
	}
}
