using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class TowerDuelScript : MonoBehaviour {

	
	public GameObject p1;
	public GameObject p2;
	
	public GameObject anim1;
	public GameObject anim2;
	
	private bool playing = false;
	
	public string[] keys;
	
	
	private string p1Key;
	private string p2Key;
	
	public TextMesh p1Text;
	public TextMesh p2Text;
	public TextMesh centerText;
	
	private int p1Score = 0;
	private int p2Score = 0;
	
	private List<GameObject> blocks = new List<GameObject>();
	
	public GameObject blockPrefab;
	
	// Use this for initialization
	void Start () {
		p1Text.text = "";
		p2Text.text = "";
	}
	
	// Update is called once per frame
	void Update () {
		if (Input.GetKey("escape")){
			Application.LoadLevel(0);
		}
		
		anim1.animation.CrossFade("idle");
		anim2.animation.CrossFade("idle");
		
		if (!playing){
			centerText.text = "Press Space!";
			if (p1Score>p2Score){
				p1Text.text = "WIN";
				p2Text.text = "LOSE";
			}else if (p2Score > p1Score){
				p1Text.text = "LOSE";
				p2Text.text = "WIN";
			}else{
				p1Text.text = "TIE";
				p2Text.text = "TIE";
			}
			
			if (Input.GetKeyDown("space")){
				centerText.text = "FIRST TO 20 WINS!";
				
				playing = true;
				p1Key = keys[Random.Range(0,keys.Length)];
				p2Key = keys[Random.Range(0,keys.Length)];
				
				p1Score = 0;
				p2Score = 0;
				
				p1.transform.position = Vector3.right * -3f;
				p2.transform.position = Vector3.right * 3f;
				
				
				for (int i=0; i<blocks.Count; i++){
					Destroy(blocks[i]);
				}
				blocks = new List<GameObject>();
			}
			
		}else{
			//playing
			
			p1Text.text = "PRESS " + p1Key.ToUpper() + "\n" + p1Score.ToString();;
			p2Text.text = "PRESS " + p2Key.ToUpper() + "\n" + p2Score.ToString();;
			
			
			if (Input.GetKeyDown(p1Key)){
				anim1.animation.Play("crouch");
				p1Key = keys[Random.Range(0,keys.Length)];
				
				
				GameObject newBlock = (GameObject)GameObject.Instantiate(blockPrefab);
				newBlock.transform.position = new Vector3(-3,p1Score*0.5f,0) + (Vector3.up*0.25f);
				Color randCol1 = new Color();
				randCol1.r = Random.Range(0.5f,1f);
				randCol1.g = Random.Range(0.5f,1f);
				randCol1.b = Random.Range(0.5f,1f);
				newBlock.renderer.material.SetColor("_Color", randCol1);
				blocks.Add(newBlock);
				
				p1Score++;
				
				p1.transform.position += Vector3.up * 0.5f;
			}
			
			
			if (Input.GetKeyDown(p2Key)){
				anim2.animation.Play("crouch");
				p2Key = keys[Random.Range(0,keys.Length)];
				
				
				GameObject newBlock2 = (GameObject)GameObject.Instantiate(blockPrefab);
				newBlock2.transform.position = new Vector3(3,p2Score*0.5f,0) + (Vector3.up*0.25f);
				Color randCol2 = new Color();
				randCol2.r = Random.Range(0.5f,1f);
				randCol2.g = Random.Range(0.5f,1f);
				randCol2.b = Random.Range(0.5f,1f);
				newBlock2.renderer.material.SetColor("_Color", randCol2);
				blocks.Add(newBlock2);
				
				p2Score++;
				
				p2.transform.position += Vector3.up * 0.5f;
			}
			
			Vector3 targetPos = Vector3.zero;
			if (p1.transform.position.y > p2.transform.position.y){
				targetPos = new Vector3(0, p1.transform.position.y, 0);
			}else{
				targetPos = new Vector3(0, p2.transform.position.y, 0);
			}
			transform.position = Vector3.Lerp(transform.position, targetPos, 20f * Time.deltaTime);
			
			if (p1Score>=20 || p2Score>=20){
				playing = false;
			}
		}
		
	}
}
