using UnityEngine;
using System.Collections;

public class SayAaaahScript : MonoBehaviour {
	
	public GameObject animObj;
	
	private bool grounded = false;
	
	private Vector3 lookDir = Vector3.right;
	
	private bool running = false;
	
	private float yMove = 0f;
	
	
	public GameObject camObj;
	
	private bool dead = false;
	
	private Vector3 startPos;
	
	public TextMesh screenText;

	// Use this for initialization
	void Start () {
		lastPos = transform.position;
		startPos = transform.position;
	}
	
	// Update is called once per frame
	void Update () {
		
		if (Input.GetKeyDown("escape")){
			Application.LoadLevel(0);
		}
		
		
		if (!dead){
			
			screenText.text = "";
			
			running = false;
			
			float xMove = 0f;
			if (Input.GetKey("right")){
				lookDir = Vector3.right;
				running = true;
				xMove += 6f;
			}
			if (Input.GetKey("left")){
				lookDir = -Vector3.right;
				running = true;
				xMove -= 6f;
			}
			Quaternion lastRot = transform.rotation;
			transform.LookAt(transform.position + lookDir);
			transform.rotation = Quaternion.Slerp(lastRot, transform.rotation, 20f * Time.deltaTime);
			
			
			
		
			
			
			
			yMove -= 15f * Time.deltaTime;
			if (yMove <-8f) yMove = -8f;
			
			
			
			
			
			
			
			if (grounded){
				if (Input.GetKeyDown("up")){
					yMove = 8f;
					grounded = false;
					transform.position += Vector3.up*0.11f;
				}
			}
			
			transform.position += new Vector3(xMove,yMove,0) * Time.deltaTime;
			transform.position = new Vector3(transform.position.x, transform.position.y, 0);
			
			
			Ray moveRay = new Ray(lastPos, transform.position-lastPos);
			RaycastHit moveHit = new RaycastHit();
			float moveLength = Vector3.Distance(lastPos, transform.position);
			if (Physics.Raycast(moveRay, out moveHit, moveLength)){
				if (moveHit.collider.gameObject.layer == 0){
					//ground
					
					transform.position = moveHit.point + (moveHit.normal*0.1f);
					grounded = true;
					//yMove = 0f;
					
				}else{
					//damaging!
					dead = true;
				}
			}
			
			Ray groundRay = new Ray(transform.position, -Vector3.up);
			RaycastHit groundHit = new RaycastHit();
			if (Physics.Raycast(groundRay, out groundHit, 0.6f)){
				grounded = true;
				transform.position = groundHit.point + (Vector3.up * 0.5f);
				yMove = 0f;
				
				if (groundHit.collider.gameObject.layer == 8) dead = true;
			}else{
				grounded = false;
			}
			
			
			if (grounded){
				if (running){
					animObj.animation.CrossFade("run");
				}else{
					animObj.animation.CrossFade("idle");
				}
			}else{
				if (yMove>0){
					animObj.animation.CrossFade("rise");
				}else{
					animObj.animation.CrossFade("fall");
				}
			}
			
			
			if (transform.position.y<3f){
				camObj.transform.position = new Vector3(camObj.transform.position.x, transform.position.y-2f, camObj.transform.position.z);
				if (camObj.transform.position.y<-98){
					camObj.transform.position = new Vector3(camObj.transform.position.x, -98f, camObj.transform.position.z);
					screenText.text = "YOU WIN!";
				}
			}else{
				camObj.transform.position = new Vector3(camObj.transform.position.x, 1f, camObj.transform.position.z);
			}
			
			lastPos = transform.position;
		}else{
			//dead
			animObj.animation["rise"].speed = 0f;
			animObj.animation["fall"].speed = 0f;
			animObj.animation["idle"].speed = 0f;
			animObj.animation["run"].speed = 0f;
			
			screenText.text = "FAIL, PRESS SPACE";
			
			if (Input.GetKeyDown("space")){
				transform.position = startPos;
				lastPos = transform.position;
				yMove = 0f;
				dead = false;
				animObj.animation["rise"].speed = 1f;
				animObj.animation["fall"].speed = 1f;
				animObj.animation["idle"].speed = 1f;
				animObj.animation["run"].speed = 1f;
			}
		}
		
	}
	
	private Vector3 lastPos;
}
