using UnityEngine;
using System.Collections;

public class FineGentlemenScript : MonoBehaviour {

	
	private bool playing = false;
	
	private bool p1Pressed = false;
	private bool p2Pressed = false;
	
	public GameObject P1;
	public GameObject P2;
	
	private Vector3 p1Pos = Vector3.zero;
	private Vector3 p2Pos = Vector3.zero;
	
	public TextMesh p1Text;
	public TextMesh p2Text;
	
	private float startTime = 0f;
	
	public TextMesh counterText;
	
	private Vector3 camPos = new Vector3(0,0,-5.6f);
	
	
	public GameObject p1Strong;
	public GameObject p1Flustered;
	
	public GameObject p2Strong;
	public GameObject p2Flustered;
	
	
	private Vector3 giraffe1Pos = Vector3.zero;
	private Vector3 giraffe2Pos = Vector3.zero;
	
	public GameObject giraffe1;
	public GameObject giraffe2;
	
	public TextMesh result1;
	public TextMesh result2;
	
	// Use this for initialization
	void Start () {
		result1.text = "";
		result2.text = "";
	}
	
	private float camelVanish = 0f;
	
	public GameObject blather1;
	public GameObject blather2;
	
	// Update is called once per frame
	void Update () {
		
		if (Input.GetKeyDown("escape")) Application.LoadLevel(0);
		
		p1Pressed = false;
		if (Input.GetKey("a")) p1Pressed = true;
		p2Pressed = false;
		if (Input.GetKey("l")) p2Pressed = true;
		
		if(p1Pressed){
			p1Text.text = "";
		}else{
			p1Text.text = "HOLD 'A'";
		}
		
		if(p2Pressed){
			p2Text.text = "";
		}else{
			p2Text.text = "HOLD 'L'";
		}
		
		
		blather1.renderer.enabled = false;
		blather2.renderer.enabled = false;
		if (playing && p1Pressed){
			blather1.renderer.enabled = true;
		}
		if (playing && p2Pressed){
			blather2.renderer.enabled = true;
		}
		
		if (!playing){
			
			if (p1Pressed){
				p1Pos = new Vector3(0,0,4.11f);
			}else{
				p1Pos = new Vector3(-5,0,4.11f);
			}
			if (p2Pressed){
				p2Pos = new Vector3(0,0,4.11f);
			}else{
				p2Pos = new Vector3(5,0,4.11f);
			}
			
			if (p1Pressed && p2Pressed){
				startTime -= Time.deltaTime;
			}else{
				startTime = 4f;
			}
			
			counterText.text = "";
			camPos = new Vector3(0,0,-5.6f);
			if (startTime <=3f){
				counterText.text = "3";
				camPos = new Vector3(0,0,-4.6f);
			}
			if (startTime <=2f){
				counterText.text = "2";
				camPos = new Vector3(0,0,-3.6f);
			}
			if (startTime <=1f){
				counterText.text = "1";
				camPos = new Vector3(0,0,-2.6f);
				
			}
			if (startTime<=0f){
				counterText.text = "";
				startTime = 4f;
				camPos = new Vector3(0,0,-5.6f);
				//start play
				
				
				result1.text = "";
				result2.text = "";
				
				attention = 0f;
				
				playing = true;
				
			}
			
			if (Time.time>camelVanish){
				giraffe1Pos = new Vector3(-8.907534f,0,6.032964f);
				giraffe2Pos = new Vector3(8.907534f,0,6.032964f);
			}
			
		}else{
			//playing
			
			
			
			
			
			if (p1Pressed){
				attention +=10f*Time.deltaTime;
			}
			if (p2Pressed){
				attention -=10f*Time.deltaTime;
			}
			//print(attention);
			
			if (attention>30f) attention = 30f;
			if (attention<-30f) attention = -30f;
			
			attentionObject.transform.localPosition = new Vector3(attention*0.15f, -3.04f, 5.1f);
			if (p1Pressed && p2Pressed) attentionObject.transform.position += new Vector3(Random.Range(-0.05f,0.05f),Random.Range(-0.05f,0.05f),Random.Range(-0.05f,0.05f));
			
			
			if (attention>16) P2.transform.position = p2Pos + new Vector3(Random.Range(-0.2f,0.2f),Random.Range(-0.2f,0.2f),Random.Range(-0.2f,0.2f));
			if (attention<-16) P1.transform.position = p1Pos + new Vector3(Random.Range(-0.2f,0.2f),Random.Range(-0.2f,0.2f),Random.Range(-0.2f,0.2f));
			
			
			float camZoom = attention;
			if (camZoom<0) camZoom*=-1;
			camZoom *= 0.05f;
			
			camPos.z = -5.6f + camZoom;
			camPos.x = attention * 0.03f;
			
			
			if (attention<=-30f){
				result1.text = "LOSE!";
				result2.text = "WIN!";
				playing = false;
				camelVanish = Time.time + 2f;
			}
			if (attention>=30f){
				result1.text = "WIN!";
				result2.text = "LOSE!";
				playing = false;
				camelVanish = Time.time + 2f;
			}
			
			if (attention<-25){
				giraffe1Pos = new Vector3(-0.7860174f,0,6.032964f);
			}else{
				giraffe1Pos = new Vector3(-8.907534f,0,6.032964f);
			}
			if (attention>25){
				giraffe2Pos = new Vector3(0.7860174f,0,6.032964f);
			}else{
				giraffe2Pos = new Vector3(8.907534f,0,6.032964f);
			}
			
		}
		
		
		
		
		
		if (p1Pressed){
			p1Strong.renderer.enabled = true;
			p1Flustered.renderer.enabled = false;
		}else{
			p1Strong.renderer.enabled = false;
			p1Flustered.renderer.enabled = true;
		}
		if (p2Pressed){
			p2Strong.renderer.enabled = true;
			p2Flustered.renderer.enabled = false;
		}else{
			p2Strong.renderer.enabled = false;
			p2Flustered.renderer.enabled = true;
		}
		
		P1.transform.position = Vector3.Lerp(P1.transform.position, p1Pos, 20 * Time.deltaTime);
		P2.transform.position = Vector3.Lerp(P2.transform.position, p2Pos, 20 * Time.deltaTime);
		
		giraffe1.transform.position = Vector3.Lerp(giraffe1.transform.position, giraffe1Pos, 20 * Time.deltaTime);
		giraffe2.transform.position = Vector3.Lerp(giraffe2.transform.position, giraffe2Pos, 20 * Time.deltaTime);
		
		transform.position = Vector3.Lerp(transform.position, camPos, 20*Time.deltaTime);
		
	}
	
	public GameObject attentionObject;
	
	private float attention = 0f;
}
