using UnityEngine;
using System.Collections;

public class DialogueCamScript : MonoBehaviour {
	
	
	private Vector3 targetPos;
	private Quaternion targetRot;
	
	
	public void SetCam(GameObject target){
		targetPos = target.transform.position;
		targetRot = target.transform.rotation;
	}

	// Use this for initialization
	void Start () {
		targetPos = transform.position;
		targetRot = transform.rotation;
	}
	
	// Update is called once per frame
	void Update () {
		
		if (Input.GetKeyDown("escape")) Application.LoadLevel(0);
		
		
		transform.position = Vector3.Lerp(transform.position, targetPos, 8f * Time.deltaTime);
		transform.rotation = Quaternion.Slerp(transform.rotation, targetRot, 8f * Time.deltaTime);
	}
}
