using UnityEngine;
using System.Collections;

public class DialogueTreeScript : MonoBehaviour {
	
	
	public GameObject targetCam;
	
	public GameObject mainCam;
	
	public bool clicked = false;
	public DialogueTreeScript otherChoice;
	
	// Use this for initialization
	void Start () {
	
	}
	
	// Update is called once per frame
	void Update () {
		
		if (renderer.enabled && !clicked){
			if (Input.GetKeyDown("mouse 0")){
				Ray screenRay = mainCam.camera.ScreenPointToRay(Input.mousePosition);
				RaycastHit screenHit = new RaycastHit();
				if (collider.Raycast(screenRay, out screenHit, 99f)){
					mainCam.GetComponent<DialogueCamScript>().SetCam(targetCam);
					if (otherChoice != null) otherChoice.clicked = true;
					clicked = true;
					foreach (Transform child in transform){
						if (child.renderer != null) child.renderer.enabled = true;
					}
				}
			}
		}
	}
}
